{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 16.09.98 - 21:36:07 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, MMWave, MMObj, MMUtils, MMWheel, Mask, ExtCtrls, MMVolume, MMConect,
  MMRingBf, MMWMixer, MMDSPObj, MMWavOut, MMHTimer, MMDesign, MMDIBCv,
  MMLevel, MMCstDlg, MMMPEG, MMDSPMtr, MMSystem, MMHook;
  
type
  TMainForm = class(TForm)
    MMDesigner1: TMMDesigner;
    Timer: TMMHiTimer;
    btnStop: TButton;
    btnStart: TButton;
    WaveOut: TMMWaveOut;
    WaveMixer: TMMWaveMixer;
    TimeLabel: TLabel;
    RingBuffer: TMMRingBuffer;
    Level1: TMMLevel;
    Connector: TMMConnector;
    Level2: TMMLevel;
    ckbLevel: TCheckBox;
    Label2: TLabel;
    lblDropOuts: TLabel;
    TrackVolume1: TMMVolume;
    Panel1: TPanel;
    Volume1: TMMWheel;
    Label5: TLabel;
    Label6: TLabel;
    Panning1: TMMWheel;
    Label7: TLabel;
    VolumeMaster: TMMWheel;
    Label8: TLabel;
    PanningMaster: TMMWheel;
    TrackVolume2: TMMVolume;
    Panel2: TPanel;
    Label11: TLabel;
    Label12: TLabel;
    Volume2: TMMWheel;
    Panning2: TMMWheel;
    MasterVolume: TMMVolume;
    ckbLoop1: TCheckBox;
    ckbLoop2: TCheckBox;
    FilePanel1: TPanel;
    btnFile1: TButton;
    FName1: TLabel;
    Label3: TLabel;
    meStart1: TMaskEdit;
    FilePanel2: TPanel;
    btnFile2: TButton;
    FName2: TLabel;
    Label9: TLabel;
    meStart2: TMaskEdit;
    MPEGFile1: TMMMPEGFile;
    MPEGFile2: TMMMPEGFile;
    OpenDialog: TOpenDialog;
    DSPMeter: TMMDSPMeter;
    Label1: TLabel;
    lblDSP: TLabel;
    Panel3: TPanel;
    Label4: TLabel;
    Label10: TLabel;
    Volume3: TMMWheel;
    Panning3: TMMWheel;
    ckbLoop3: TCheckBox;
    Panel4: TPanel;
    FName3: TLabel;
    Label14: TLabel;
    Button1: TButton;
    meStart3: TMaskEdit;
    Panel5: TPanel;
    Label15: TLabel;
    Label16: TLabel;
    Volume4: TMMWheel;
    Panning4: TMMWheel;
    ckbLoop4: TCheckBox;
    Panel6: TPanel;
    FName4: TLabel;
    Label18: TLabel;
    Button2: TButton;
    meStart4: TMaskEdit;
    TrackVolume3: TMMVolume;
    MPEGFile3: TMMMPEGFile;
    TrackVolume4: TMMVolume;
    MPEGFile4: TMMMPEGFile;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerTimer(Sender: TObject);
    procedure btnFileClick(Sender: TObject);
    procedure ckbLevelClick(Sender: TObject);
    procedure RingBufferEmpty(Sender: TObject);
    procedure VolumeChange(Sender: TObject);
    procedure PanningChange(Sender: TObject);
    procedure VolumeMasterChange(Sender: TObject);
    procedure PanningMasterChange(Sender: TObject);
    procedure meStartExit(Sender: TObject);
    procedure meStartKeyPress(Sender: TObject; var Key: Char);
    procedure ckbLoopClick(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    DropOuts: Longint;
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

// NOTE: Maximal playbacktime of TMMWaveOut is ~3.5 hours, then it will stop.
//       The Windows MMSystem works with 32 bit positions and they will overflow
//       if the 32 bit value is wrapped so we stop the device. It's always a good
//       idea to close and restart the device every 2-3 hours.
//       This limitation is removed in the Delphi4 version !

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormShow(Sender: TObject);
begin
   MessageDlg('To play and mix more than one mpeg files you need a fast machine.'+
              'Recommendable is a Pentium 200++, we use a AMD K6 233 MMX without problems.',
              mtInformation, [mbOK],0);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Timer.Enabled := False;
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStart(Sender: TObject);
begin
   Timer.Enabled := True;
 end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStop(Sender: TObject);
begin
   Timer.Enabled := False;
   lblDSP.Caption := '0 %';
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStartClick(Sender: TObject);
begin
   DropOuts := 0;
   WaveOut.Start;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   WaveOut.Stop;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TimerTimer(Sender: TObject);
begin
   TimeLabel.Caption := TimeToString(WaveOut.Position);
   lblDSP.Caption := IntToStr(DSPMeter.Value) + ' %';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.RingBufferEmpty(Sender: TObject);
begin
   inc(DropOuts);
   lblDropOuts.Caption := IntToStr(DropOuts);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ckbLevelClick(Sender: TObject);
begin
   Connector.Enabled := ckbLevel.Checked;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnFileClick(Sender: TObject);

   procedure UpdateFileLabel(Tag: integer);
   begin
      case Tag of
         0: FName1.Caption := MinimizeName(MpegFile1.FileName,FName1.Canvas,FName1.Width);
         1: FName2.Caption := MinimizeName(MpegFile2.FileName,FName2.Canvas,FName2.Width);
         2: FName3.Caption := MinimizeName(MpegFile3.FileName,FName3.Canvas,FName2.Width);
         3: FName4.Caption := MinimizeName(MpegFile4.FileName,FName4.Canvas,FName2.Width);
      end;
   end;

begin
   if OpenDialog.Execute then
   begin
      case TControl(Sender).Tag of
         0: begin
               { mark this channel as done }
               WaveMixer.InputDone[0] := True;
               { set the new filename }
               MpegFile1.FileName := OpenDialog.FileName;
               { The WaveMixer should play the channel immediately }
               { if the Input has changed }
               WaveMixer.InputDone[0] := False;
            end;
         1: begin
               { mark this channel as done }
               WaveMixer.InputDone[1] := True;
               { set the new filename }
               MpegFile2.FileName := OpenDialog.FileName;
               { The WaveMixer should play the channel immediately }
               { if the Input has changed }
               WaveMixer.InputDone[1] := False;
            end;
         2: begin
               { mark this channel as done }
               WaveMixer.InputDone[2] := True;
               { set the new filename }
               MpegFile3.FileName := OpenDialog.FileName;
               { The WaveMixer should play the channel immediately }
               { if the Input has changed }
               WaveMixer.InputDone[2] := False;
            end;
         3: begin
               { mark this channel as done }
               WaveMixer.InputDone[3] := True;
               { set the new filename }
               MpegFile4.FileName := OpenDialog.FileName;
               { The WaveMixer should play the channel immediately }
               { if the Input has changed }
               WaveMixer.InputDone[3] := False;
            end;
      end;
      UpdateFileLabel(TControl(Sender).Tag);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.VolumeChange(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: TrackVolume1.Volume := Volume1.Value;
      1: TrackVolume2.Volume := Volume2.Value;
      2: TrackVolume3.Volume := Volume3.Value;
      3: TrackVolume4.Volume := Volume4.Value;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.PanningChange(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: TrackVolume1.Panning := Panning1.Value;
      1: TrackVolume2.Panning := Panning2.Value;
      2: TrackVolume3.Panning := Panning3.Value;
      3: TrackVolume4.Panning := Panning4.Value;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.VolumeMasterChange(Sender: TObject);
begin
   MasterVolume.Volume := VolumeMaster.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.PanningMasterChange(Sender: TObject);
begin
   MasterVolume.Panning := PanningMaster.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.meStartExit(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: WaveMixer.StartPos1 := MaskToTime(meStart1.Text);
       1: WaveMixer.StartPos2 := MaskToTime(meStart2.Text);
       2: WaveMixer.StartPos3 := MaskToTime(meStart3.Text);
       3: WaveMixer.StartPos4 := MaskToTime(meStart4.Text);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.meStartKeyPress(Sender: TObject; var Key: Char);
begin
   if (Key = #13) then TMaskEdit(Sender).OnExit(Sender);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ckbLoopClick(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: WaveMixer.Loop1 := ckbLoop1.Checked;
       1: WaveMixer.Loop2 := ckbLoop2.Checked;
       2: WaveMixer.Loop3 := ckbLoop3.Checked;
       3: WaveMixer.Loop4 := ckbLoop4.Checked;
   end;
end;

end.
